//
//  OPRateLimiter.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-02-10.
//
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, OPRateLimitType) {
	OPRateLimitTypeLinear = 0,
//	OPRateLimitTypeExponential = 1,
};

@interface OPRateLimiter : NSObject

- (instancetype)initWithMinimumRateInterval:(NSTimeInterval)minimumInterval type:(OPRateLimitType)type initialDelay:(NSTimeInterval)initialDelay;

// Minimum number of seconds between events in order not to trip the rate limit
@property (readonly) NSTimeInterval minimumRateInterval;

// Type of delay to use when the rate limit has been tripped
@property (readonly) OPRateLimitType type;

// Upon initially tripping the rate limit, this it the delay that will be imposed.
@property (readonly) NSTimeInterval initialDelay;

// Returns NO if last event was more than minimumRateInterval (i.e. you did not trip the rate limit)
// Returns YES if you've tripped the rate limit
- (BOOL)registerEvent;

// Will return 0 if not rate limited, otherwise the NSTimeInterval that should be waited until trying again.
- (NSTimeInterval)rateLimitedForTimeInterval;

@end
